    
;########################################################################
;   Nastaveni editoru:	 Font VERDANA 14,  Space 8, TAB 8 
;   File Name	:VODARNA-VRT_B2_b
;   Date		:04.09.2025
;   File Version	:6.20 - verze pro MPLABX 6.20
;   HW			:Vodarna_VRT_b2b
;   Author		:VC - Allcomp (c)2025
;   VERZE		: Upravena deska pro AMARO - priprava
;*******************************************************************************
;   Description:Deska rizeni pro vodarnu napajenou z vrtu.
;				Pouzit zdroj i rele 12V		
;========================================================================
;   V.100  - základní verze. 
;   V.101  - odladeny sondy, odladena PUMPA 1 
;   V.102  - 21.8.2025 - 
;   V.2B2  - 04.09.2025 - upraveny vstupy a vystupy - priprava pro AMARO
;						- procesor PIC16F15244	
;	V.2B2_a- 23.10.2025 - opraven timeout 24 hod pro reset (odpousteni vody)
;   V.2B2_a_18446 - jiny MCU		
;========================================================================   
;      START		  ;Inicializace procesoru
;      MXDISP		  ;Zakladni smycka programu        
;*******************************************************************************
; PIC16F18446 Configuration Bit Settings

; Assembly source line config statements

; CONFIG1
  CONFIG  FEXTOSC = ECH         ; External Oscillator mode selection bits (EC above 8MHz; PFM set to high power)
  CONFIG  RSTOSC = EXT1X        ; Power-up default value for COSC bits (EXTOSC operating per FEXTOSC bits)
  CONFIG  CLKOUTEN = OFF        ; Clock Out Enable bit (CLKOUT function is disabled; i/o or oscillator function on OSC2)
  CONFIG  CSWEN = ON            ; Clock Switch Enable bit (Writing to NOSC and NDIV is allowed)
  CONFIG  FCMEN = ON            ; Fail-Safe Clock Monitor Enable bit (FSCM timer enabled)

; CONFIG2
  CONFIG  MCLRE = ON            ; Master Clear Enable bit (MCLR pin is Master Clear function)
  CONFIG  PWRTS = OFF           ; Power-up Timer Enable bit (PWRT disabled)
  CONFIG  LPBOREN = OFF         ; Low-Power BOR enable bit (ULPBOR disabled)
  CONFIG  BOREN = ON            ; Brown-out reset enable bits (Brown-out Reset Enabled, SBOREN bit is ignored)
  CONFIG  BORV = LO             ; Brown-out Reset Voltage Selection (Brown-out Reset Voltage (VBOR) set to 2.45V)
  CONFIG  ZCD = OFF             ; Zero-cross detect disable (Zero-cross detect circuit is disabled at POR.)
  CONFIG  PPS1WAY = ON          ; Peripheral Pin Select one-way control (The PPSLOCK bit can be cleared and set only once in software)
  CONFIG  STVREN = ON           ; Stack Overflow/Underflow Reset Enable bit (Stack Overflow or Underflow will cause a reset)
  CONFIG  DEBUG = OFF           ; Background Debugger (Background Debugger disabled)

; CONFIG3
  CONFIG  WDTCPS = WDTCPS_31    ; WDT Period Select bits (Divider ratio 1:65536; software control of WDTPS)
  CONFIG  WDTE = ON             ; WDT operating mode (WDT enabled regardless of sleep; SWDTEN ignored)
  CONFIG  WDTCWS = WDTCWS_7     ; WDT Window Select bits (window always open (100%); software control; keyed access not required)
  CONFIG  WDTCCS = SC           ; WDT input clock selector (Software Control)

; CONFIG4
  CONFIG  BBSIZE = BB512        ; Boot Block Size Selection bits (512 words boot block size)
  CONFIG  BBEN = OFF            ; Boot Block Enable bit (Boot Block disabled)
  CONFIG  SAFEN = OFF           ; SAF Enable bit (SAF disabled)
  CONFIG  WRTAPP = OFF          ; Application Block Write Protection bit (Application Block not write protected)
  CONFIG  WRTB = OFF            ; Boot Block Write Protection bit (Boot Block not write protected)
  CONFIG  WRTC = OFF            ; Configuration Register Write Protection bit (Configuration Register not write protected)
  CONFIG  WRTD = OFF            ; Data EEPROM write protection bit (Data EEPROM NOT write protected)
  CONFIG  WRTSAF = OFF          ; Storage Area Flash Write Protection bit (SAF not write protected)
  CONFIG  LVP = ON              ; Low Voltage Programming Enable bit (Low Voltage programming enabled. MCLR/Vpp pin function is MCLR.)

; CONFIG5
  CONFIG  CP = OFF              ; UserNVM Program memory code protection bit (UserNVM code protection disabled)

// config statements should precede project file includes.
#include <xc.inc>


;===============================================================================    
;#include "config.inc" // Konfiguracni slova
#include "psects_pic16f_MAKRO.inc" // Potrebna makra na definici sekci
;#include "pins.inc" // Definice portu
;#include "macrolib.inc" // Pomocna makra
;===============================================================================
; MAKRA  call a goto
;===============================================================================    

;===============================================================================
; Globalni symboly (pro debugging)
;===============================================================================  
		global	SEC, SONDY, TIMR_TO_P1, TIMR_TO_P2, TIM,U_S1L,U_S2L,U_S2H,U_S2U
		global	CLOCK_ADC, U_ADC
;========================================================================

		TIMUR_TO_P1		SET 100	//* 2sec [200] - pumpa VRT
		TIMUR_TO_P2		SET 200	//* 2sec [400 sec] - pumpa vodarna
		TIMUR_VENTIL	SET 60	//* 2sec [120s = 2min]
		DATA_ADR_EE	    SET	0xF80	;adresa NVMADR pro ulozeni dat do SAF 
		HEADR_ADR_EE	SET 0xFC0	;adresa NVMADR kam se zapisuje HLAVICKA   
;--------------------------------------------------------------
DATA_ADR_RAMWR	SET	0x020	;adresa RAM dat ze kterych se uklada do EEPROM	
DATA_ADR_RAMRD	SET	0x020	;adresa RAM kam se ukladaji READ DATA z EEPROM 
;----------------------------	    
;
DATA_ADR_EE	SET	0x780	;adresa NVMADR pro ulozeni dat do SAF az 0x07bf
HEADR_ADR_EE	SET	0x7C0	;adresa NVMADR kam se zapisuje HLAVICKA az 0x7DF   
;--------------------------------------------------------------
; Vlastni definice	
#define	MXDISP		MXDISP_Zakladni_smycka_programu;nazev navesti alternativne    
;#define	TEST_ADC  MERENI_ANA_VSTUPU_TEST_ADC	;alternace
C	EQU	0   
Z	EQU	2   	
;========================================================================         
;         DEKLARACE PROMENNYCH          
;========================================================================
;definice registru CLOCK
C1ms       EQU      0x0	  ;platna 1ms
C10ms      EQU      0x1	  ;platna 10ms
C100ms     EQU      0x2	  ;platna 100ms
C1s        EQU      0x3	  ;platna 1s
C1m        EQU      0x4	  ;platna 1 min
C05s       EQU      0x5	  ;platna 0.5s
FADC	   EQU	    0x7	  ;Flag mereni ADC
;===========================================
;definice registru CLOCK
		C1ms       EQU      0x0	  ;platna 1ms
		C10ms      EQU      0x1	  ;platna 10ms
		C100ms     EQU      0x2	  ;platna 100ms
		C1s        EQU      0x3	  ;platna 1s
		C1m        EQU      0x4	  ;platna 1 min
		C05s       EQU      0x5	  ;platna 0.5s
		FADC	   EQU	    0x7	  ;Flag mereni ADC
;======================================================
;definice registru SONDY
		S1L        EQU      0x0	  ;sonda S1L zaplavena
		S2L        EQU      0x1	  ;sonda S2L zaplavena
		S2H        EQU      0x2	  ;sonda S2H zaplavena
		S2U        EQU      0x3	  ;sonda S2H zaplavena
		SPRESS	   EQU		0x4	  ;cidlo tlaku (sepnuto L)
;======================================================
;definice registru TIM
		TO_P1      EQU      0x0	  ;TO PUMPA 1 - nautila
		TO_P2      EQU      0x1	  ;TO PUMPA 2 - cerpadlo
		TO_VENTIL  EQU		0x2   ;TO VENTIL - odpousteni	
		TO_ERR1	   EQU		0x6	  ;TO PUMPY1 prošel
	    TO_ERR2	   EQU		0x7	  ;TO PUMPY2 prošel
;======================================================	   	   

//==============================================================================
// Alokace EEPROM   DATA_ADR_EE
//==============================================================================
;Prvotni zapsani defaultnich hodnot do EEPROM
PSECT_CODE_ABS EEPROM,DATA_ADR_EE   ;0x07A0	;
EEPROM_memory:	    ;Adresa_485,Pocitadlo otevreni 3byte	
		DW 111,123,3,2,254,2    ;adresa_485,stav pocitadla vynulovan  
	;    
PSECT_CODE_ABS EEPROM1,HEADR_ADR_EE
Header_memory:	    ;HLAVICKA souboru na adrese 0x07C0	
		DW '*', 'S', 'W', ':', 'B', '2', '2','_','1','8','4','4','6'	;cislo SW
		DW 'H', 'W', ':', 'V', 'O', 'D', 'A', 'R'	;cislo HW
		DW 'N', 'A', '-', 'V', 'R', 'T', 'B', '2'	;cislo HW pokracovani
		DW 'B', '-', 'A', 'L', 'L', 'C','O','M','P'	;Allcomp

//==============================================================================
// Alokace programove pameti (fixni adresa 0x00 - reset vektor)
//==============================================================================
PSECT_RAM DATA1 // DS = delka v 
;    
SEC:		DS 1
MIN:		DS 1
CLOCK:		DS 1	;praporek casu
CLOCK_1us:	DS 1
CLOCK_1ms:	DS 1
CLOCK_10ms:	DS 1
CLOCK_01s:	DS 1
CLOCK_256:	DS 1
    ;
TIM:		DS 1    
TIM1:		DS 1    
SWITCH:		DS 1
SONDY:		DS 1
CLOCK_ADC:		DS 1		

U_ADC:			DS 1
U_S1L:			DS 1
U_S2L:			DS 1
U_S2H:			DS 1
U_S2U:			DS 1		
;    //------------------	Registry pro display
TIMR_TO_P1:		DS 1
TIMR_TO_P2:		DS 1
TIMR_TO_V:		DS 1
TO_24HL:		DS 1
TO_24HH:		DS 1			
CITAC:			DS 1
END_EEPROM:		DS 1	;EEPROM 32
;========================================================================  
;-------  DEFINICE PORTU PIC16F15244 ----------------------
#define	    PRG_1		PORTA,0	;
#define	    PRG_2		PORTA,1	;
#define	    PRG_3		PORTA,3	;		
#define	    SW_PRESS	PORTA,2	; SW_PRESS
#define	    OUT_1kHz	PORTA,4	;
#define	    PA5			PORTA,5	; nevim proc ale nejde vstup
;----------------------------------
#define	    LED_T		PORTC,0	;TEMP_1
#define	    SONDA_1L	PORTC,1	;Sonda Sonda studna 1L
#define	    SONDA_2L	PORTC,2	;Sonda nadrz 2L	
#define	    LED_2L	    PORTC,3	;
#define	    LED_1L  	PORTC,4	;
#define	    SONDA_2U	PORTC,5	;Sonda nadrz 2U
#define	    SONDA_2H	PORTC,6	;Sonda nadrz 2H
#define	    LED_2H  	PORTC,7	;
;----------------------------------
#define	    VENTIL		PORTB,4	;LED Sondy nadrz 2U		
#define	    PUMPA_2		PORTB,5	;LED Sondy nadrz 2U		
#define	    PUMPA_1		PORTB,6	;LED Sondy nadrz 2U		
#define	    LED_2U		PORTB,7	;LED Sondy nadrz 2U	
		
;========================================================================
;#define	    PIN_WS		PORTC,0	;OUT_G		
;========================================================================
;  		
 
//------    Instrukce ve stejne sekci jsou vzdy ve stejne strance    
;========================================================================
PSECT_CODE_ABS RESET_VEC,0x00
		global	_RESET
_RESET:
    Mpgoto	_START_ASSEMBLER
//========================================================================
// Alokace programove pameti (fixni adresa 0x04 - interrupt vektor)
//========================================================================    
PSECT_CODE_ABS INTERRUPT_VEC,0x04
		global	_INT_RX_UART
;========================================================================  
;	Interupt - preruseni
;========================================================================
	;	Zacatek preruseni Rx
;========================================================================
	;
_INT_RX_UART:
	
		return
;========================================================================
;	Ukonceni  preruseni Rx
;========================================================================    
;
;========================================================================    
PSECT_CODE MAIN_PROG
		global	_START_ASSEMBLER 
;======================================================================== 	
_START_ASSEMBLER:         ;-------- Inicializace PORTu str.180 ------------------
;========================================================================  
;========================================================================  	
    Mpcall  _INIT_PORT_MODULE
    Mpcall  _OSCILATOR_MODULE	;str.100; Reg.str.116
;   Mpcall    INTERUPS_		;str.117; Reg.str.138
;   call    WDT_MODULE		;str.146; Reg.str.153
;   call    NVM_MODULE		;str.154; Reg.str.171
;   call    INIT_PORT		;str.172; Reg.str.179A,184C
;   call    PPS_MODULE		;str.185; Reg.str.193
;   call    FVR_MODULE		;str.209; Reg.str.211	;Reference
    Mpcall  _ADC_MODULE		;str.215; Reg.str.228
;   call    DAC_MODULE		;str.229; Reg.str.233
;   call    COMPARATOR		;str.244; Reg.str.253
;   call    ZCD_MODULE		;str.254; Reg.str.259	;Zerro cross detect
;   call    TMR0_MODULE		;str.260; Reg.str.265	;TIMER 0
;   Mpcall TMR1_MODULE		;str.266; Reg.str.278	;TIMER 1
    Mpcall  _TMR2_MODULE	;str.279; Reg.str.298	;TIMER 2
;   call    CCP_MODULE		;str.299; Reg.str.310	;CAPTURE/COMPARE
;   call    PWM_MODULE		;str.311; Reg.str.317	;PULSE-WIDTH MODULATION
;   call    CWG_MODULE		;str.318; Reg.str.342	;COMPL. WAVEFORM GEN. 
;   call    CLC_MODULE		;str.343; Reg.str.358	;CONFIGURABLE LOGIC CELL
;   call    MSSP1_MODULE	;str.360; Reg.str.410	;SPI, I2C
;   Mpcall  _EUSART_MODULE	;str.411; Reg.str.435   ;seriova komunikace 
    Mpcall  _START_OSTATNI   
;========================================================================      
;========================================================================
;	    FORMALNI START PROGRAMU	
;========================================================================    
MXDISP_Zakladni_smycka_programu:	;Zakladni_smycka_programu: 
;======================================================================== 
    
		BANKSEL PORTA
		;bcf    INTCON,7	    ;GIE   ZAKAZE INTERRUPT  	    
		;
		bcf		CLOCK,C1ms	  
		BANKSEL PIR4			;
		btfss   PIR4,1			;TMR2IF         ;
		goto    MXDISP			;jump if not
		bcf		PIR4,1			;TMR2IF         ;3.8 kHz
		banksel CLOCK
; ======  VALID  1 ms  ===========
		;.............................;generator 1kHz
		banksel PORTA
		btfss	LATA,4			;PORTA,4
		goto	$+3
		bcf		LATA,4
		goto	$+2
		bsf		LATA,4
;............................;generator 1kHz			
		banksel PORTA
		bcf		CLOCK,C10ms
		decfsz  CLOCK_1ms,F
		goto    MXDISP
		movlw	25
		movwf	CLOCK_1ms
		bsf		CLOCK,C10ms
; ======  VALID  10 ms  ==========
		call	TEST_ADC
		;+++call	TEST_SONDY		;testuje sondy a tlakovy spinac
		bcf		LED_T
		banksel CLOCK
		bcf	    CLOCK,C100ms
		decfsz  CLOCK_10ms,F
		goto    MXDISP
		movlw   10
		movwf   CLOCK_10ms
		bsf	    CLOCK,C100ms
; ======  VALID  100 ms  ========================
		call	TEST_SONDY		;testuje sondy a tlakovy spinac
		;bsf		LED_T
		call	TEST_PUMPA1		;
		bcf	    CLOCK,C1s
		bcf	    CLOCK,C05s
MX_clk100:
		decfsz  CLOCK_01s,F
		goto    MX_500
		goto    MX_1000
MX_500:
		movf   CLOCK_01s,w
		andlw   00000111B
		sublw   5
		btfss   STATUS,2
		goto    MXDISP
		bsf	    CLOCK,C05s	    ;plati 500ms
; ======  VALID  500 ms  ===============
		
		goto    MXDISP
MX_1000:
		banksel CLOCK_01s
		movlw   10
		movwf   CLOCK_01s
		bsf	    CLOCK,C1s
; ======  VALID  1 sec   ===============
	;-----------------------------------
		clrwdt
		banksel	PORTA
		incf	SEC,F
		btfss	SEC,0
		call	TEST_TIM_P1		;odpocitava po 2 sec
		movlw	30
		subwf	SEC,w
		btfsc	STATUS,2
		goto	Valid_30
		movlw	60				;.60
		subwf	SEC,w
		btfss	STATUS,2
		goto	MXDISP
		clrf	SEC
		bsf		CLOCK,C1m			;platna minuta
		goto	Val_1m
Valid_30:    ;platnych 30 sec -------
		goto	MXDISP
Val_1m:	    ;VALID  1 min ----------
		incf	MIN,F
		call	TIMER_24H		;+++1440 min = 24 hod		
		goto	MXDISP
;===============================================================================
;	            FORMALNI KONEC PROGRAMU
;===============================================================================

;====== 	    P O D P R O G R A M Y        =================================== 
;===============================================================================    
TIMER_24H:
		;zde reset po 24 hodinach = 1440 min = 0x5A0
		banksel	TO_24HL
		decfsz	TO_24HL
		return
		decfsz	TO_24HH
		return
		RESET			;spustí odpousteni vody
		return
		
;===============================================================================    

;========================================================================    
TEST_SONDY:						;100ms
		/*definice registru SONDY
		S1L    EQU  0x0	  ;sonda S1L potopena nautila	- RC1
		S2L    EQU  0x1	  ;sonda S2L zaplavena			- RC2
		S2H    EQU  0x2	  ;sonda S2H zaplavena			- RC6
		S2U    EQU  0x3	  ;sonda S2U zaplavena			- RC5
		SPRESS EQU	0x4	  ;cidlo tlaku (sepnuto L)		- RA5
		*/
		banksel	PORTC
		clrf	SONDY	;zhasnou vsechny LED jednotlivych sond
		bsf		LED_1L	;RC4
		bsf		LED_2L	;RC3
		bsf		LED_2H	;RC7
		bsf		LED_2U	;RB7
		;....................
		banksel	SONDY
		clrf	STATUS
		comf	U_S1L,w			;negace
		btfsc	STATUS,2		;ZERO
		goto	$+3
		bsf		SONDY,S1L		;je ZERO (U_sondy=0xFF)
		bcf		LED_1L
		;....................
		clrf	STATUS
		comf	U_S2L,w			;negace
		btfsc	STATUS,2		;ZERO
		goto	$+3
		bsf		SONDY,S2L		;je ZERO (U_sondy=0xFF)
		bcf		LED_2L
		;....................
		comf	U_S2H,w			;negace
		btfsc	STATUS,2		;ZERO
		goto	$+3
		bsf		SONDY,S2H		;je ZERO (U_sondy=0xFF)
		bcf		LED_2H
		;....................
		clrf	STATUS
		comf	U_S2U,w			;negace
		btfsc	STATUS,2		;ZERO
		goto	$+3
		bsf		SONDY,S2U		;je ZERO (U_sondy=0xFF)
		bcf		LED_2U
		;....................
		banksel	PORTA
		btfsc	SW_PRESS			;SW_PRESS	;pozadavek na sepnuti cerpadla
		goto	$+3
		bsf		SONDY,SPRESS
		;bcf	LED_PRESS		;svitila by LED_PRESS, kdyby tam byla
		nop
		return
;/==============================================================================
;===============================================================================    
TEST_ADC:   ;analog.mereni 
;===============================================================================    
	banksel		CLOCK_ADC		;		Lze pouzit vstupy:  RA0,RA1,RA2,RA4,RA5,RB5,RB6,RB7,RC2,RC3,RC4,RC5	
	movf		CLOCK_ADC,w
	andlw		0x03			;omezeni skoku max 0x3
	brw  
	;
	goto    ADC_S1L		;RC1		
	goto    ADC_S2L		;RC2
	goto    ADC_S2H		;RC6	 
	goto    ADC_S2U		;RC5

;---------------------------------------------    
ADC_S1L:    ;Napeti analog     
	call    ADC_CYKL
	banksel U_ADC
	movwf   U_S1L	    ;ulozit 
    ;..................................
	BANKSEL ADPCH	    ;Prepne AMX  str.528
	movlw   010010B	    ;Select channel RC2 
	movwf   ADPCH
	movlw		1
	movwf		CLOCK_ADC
	return
;---------------------------------------------    
ADC_S2L:    ;Napeti analog     
	call    ADC_CYKL
	banksel U_ADC
	movwf   U_S2L	    ;ulozit 
    ;..................................
	BANKSEL ADPCH	    ;Prepne AMX  str.528
	movlw   010110B	    ;Select channel RC6
	movwf   ADPCH
	movlw		2
	movwf		CLOCK_ADC
	return
;---------------------------------------------    
ADC_S2H:    ;Napeti analog     
	call    ADC_CYKL
	banksel U_ADC
	movwf   U_S2H	    ;ulozit 
    ;..................................
	BANKSEL ADPCH	    ;Prepne AMX  str.528
	movlw   010101B	    ;Select channel RC5
	movwf   ADPCH
	banksel	CLOCK_ADC
	movlw	3
	movwf	CLOCK_ADC
	return
;---------------------------------------------    
ADC_S2U:    ;Napeti analog     
	call    ADC_CYKL
	banksel U_ADC
	movwf   U_S2U	    ;ulozit 
    ;..................................
	BANKSEL ADPCH	    ;Prepne AMX  str.528
	movlw   010001B	    ;Select channel RC1 0x11
	movwf   ADPCH	
	banksel	CLOCK_ADC
	clrf	CLOCK_ADC
	return	
;--------------------------------------------

;--------------------------------------------    
ADC_CYKL:
	BANKSEL ADCON0		;str.532
	bsf     ADCON0,0	;GO/DONE - Start conversion
	btfsc   ADCON0,0	;Is conversion done?
	goto    $-1		;No, test again
	banksel	CLOCK_ADC
	incf	CLOCK_ADC,f	
	BANKSEL ADRESH	;hornich 8 bit
	movf    ADRESH,W	;Read upper 8 bits
	
	return
;===================================================================	    
   		
;
;/==============================================================================		
TEST_PUMPA1:		;Nautila ve vrtu 230V je PUMPA1, cerpadlo je PUMPA2
;PUMPA1:
;SONDA 1L musí být potopena = SONDA 1L=>L (SONDY,0 => H)
;Start napousteni kdyz SONDA 2H je na suchu
;konec dopousteni kdyz SONDA 2U je zaplavena
;TO PUMPA 1 je nastaven na dobu behu v sec TIMUR_TO_P1, nuluje se Resetem
;------------------------------------------------------------------------
		banksel	SONDY
		btfss	SONDY,S1L		;je voda ve vrtu?	
		goto	Pumpa_1_off		;ochrana nautily proti běhu nasucho
		btfsc	SONDY,S2U		;Je nadrz plna?
		goto	Pumpa_1_off		;
		btfsc	SONDY,S2H		;Ma se dopoustet voda do nadrze?
		goto	TEST_PUMPA2
		btfss	TIM,TO_P1
		call	TIMER_TO_P1		;zapnuti PUMPY 1
		goto	TEST_PUMPA2
;================================================						
;
Pumpa_1_off:
		;;zde vypnuti nautily
		bcf		PUMPA_1
		bcf		TIM,TO_P1		;nulovani TO_P1
;===================================================
;		
;		
TEST_PUMPA2:					;Cerpadlo 230V
		btfss	SONDY,S2L		;neni voda v nadrzi
		goto	Pumpa_2_off
		btfss	SONDY,SPRESS	;pozadavek na sepnuti H
		goto	Pumpa_2_off		;je natlakovano...
		btfsc	TIM,TO_P2
		return
		call	TIMER_TO_P2		;zapnuti PUMPY 2
		return
Pumpa_2_off:
		bcf		PUMPA_2
		bcf		TIM,TO_P2		;nulovani TO_P2
		return
;===================================================
TIMER_TO_P1:
		btfsc	TIM,TO_ERR1
		return
		movlw	TIMUR_TO_P1
		movwf	TIMR_TO_P1
		bsf		TIM,TO_P1
		bsf		PUMPA_1			;ZAPNE PUMPA1
		return
TIMER_TO_P2:
		btfsc	TIM,TO_ERR2
		return
		movlw	TIMUR_TO_P2
		movwf	TIMR_TO_P2
		bsf		TIM,TO_P2
		bsf		PUMPA_2			;ZAPNE PUMPA2
		return	
TIMER_TO_VENTIL:				;nastaveni odposteni vody po dobu TIMUR_VENTIL
		banksel	TIMR_TO_V
		bsf		TIM,TO_VENTIL
		movlw	TIMUR_VENTIL
		banksel	TIMR_TO_V
		movwf	TIMR_TO_V
		bsf		VENTIL
		return		
;===================================================		
TEST_TIM_P1:						;*2sec
		bsf		LED_T	;+++
		banksel	TIM
		btfss	TIM,TO_P1
		goto	TEST_TIM_P2
		decfsz	TIMR_TO_P1,f
		goto	TEST_TIM_P2
Test_TIM_P1_Err:		
		bcf		TIM,TO_P1
		bsf		TIM,TO_ERR1
		bcf		PUMPA_1			;VYPNE PUMPA1
TEST_TIM_P2:
		
		btfss	TIM,TO_P2
		goto	TEST_TO_VENTIL
		decfsz	TIMR_TO_P2,f
		goto	TEST_TO_VENTIL
		bcf		TIM,TO_P2
		bsf		TIM,TO_ERR2
		bcf		PUMPA_2			;VYPNE PUMPA2
		;goto	TEST_TO_VENTIL
TEST_TO_VENTIL:		
		banksel	TIMR_TO_V
		btfss	TIM,TO_VENTIL
		return
		decfsz	TIMR_TO_V,f
		return
		bcf		TIM,TO_VENTIL
		bcf		VENTIL
		return		
;===============================================================================   

;===============================================================================    
PSECT_CODE INIT_ROUTINE	;Memory BANK str.34    
;===============================================================================    
_INIT_PORT_MODULE:   
		BANKSEL PORTA	;BANK 0
		clrf    PORTA	;Str.179
		clrf    PORTB	;
		clrf    PORTC	;
		BANKSEL LATA	;
		clrf    LATA	;
		clrf    LATB	;
		clrf    LATC	;
		BANKSEL ANSELA	;Set 0 - digital I/O, 1 - analog
		clrf    ANSELA	;
		clrf    ANSELB	;
		clrf    ANSELC	;
		bsf		ANSELC,1	;SONDA_1L
		bsf		ANSELC,2	;SONDA_2U
		bsf		ANSELC,6	;SONDA_2H
		bsf		ANSELC,5	;SONDA_2L
		;bsf		ANSELA,5	;cidlo tlaku
          ;..............................
		BANKSEL	TRISA	;Set 1 - INPUT, 0 - OUTPUT
		clrf	TRISA	;
		clrf	TRISB
		clrf	TRISC	;
		bsf		TRISA,2	;SW_PRESS - cidlo tlaku
		bsf		TRISA,5	;SW_PRESS - cidlo tlaku
		bsf		TRISC,1	;SONDA_1L
		bsf		TRISC,2	;SONDA_2U
		bsf		TRISC,6	;SONDA_2H
		bsf		TRISC,5	;SONDA_2L
		
		;.........................
;		banksel	INLVLC
;		bcf		INLVLC,1
	
		return
;===============================================================================
_OSCILATOR_MODULE:    
;===============================================================================    
;      --------- Oscilator module str. 73 -------------------------------------
;===============================================================================    
		banksel   OSCCON1
		clrf      OSCCON1	    ;str.132
		clrf      OSCCON2
		banksel   OSCEN	    ;str.139
		clrf      OSCEN
		banksel   OSCFRQ	    ;str.139
		movlw     00000011B   ; 8 MHz  
		movwf     OSCFRQ
		return
;===============================================================================    
_WDT_MODULE:    ;      --------- WDT ----- str.98  -----------------------------
;===============================================================================    
		banksel   WDTCON0	            ;BANK 16  str.164
		movlw     00001111B   ;32 sec
		movwf     WDTCON0
		return
;=============================================================================== 
_TMR2_MODULE:    
;      --------- TMR2 ----- str.300  -------------------------------------
;===============================================================================    
		banksel   T2CLKCON      ;str.303
		movlw     0x01
		movwf     T2CLKCON      ;Fosc/4
		banksel   T2CON			;Str.305
		movlw     10100000B		;on/4 /0		
		movwf     T2CON
		banksel   T2PR			;str.302
		movlw     200			;doladeni hodin na 1ms 
		movwf     T2PR
		return
;=============================================================================== 
_EUSART_MODULE:  ;str.220 jiny datasheet  
;      --------- EUSART ------- 9600 Baud ------------------------------
;      --------- Seriova komunikace 1  SYNC=0,BRGH=1,BRG16=1  str.412 / 436
;		banksel   BAUD1CON	    ;Baud Rate Control Register 1;
;		movlw     00000000B     ;str. 433 ,8bit
;		movwf     BAUD1CON
;		bsf	      BAUD1CON,3    ;BRG16      ;str.433
	;movlw     low(RYCHLOST192)   ;.103 - 19.2k, 
	;movwf     SP1BRGL	        ;str.434
	;movlw     high RYCHLOST192
	;movwf     SP1BRGH
;		clrf      TX1STA		;str.431
;		bsf	      TX1STA,5	    ;TXEN
;		bsf	      TX1STA,2	    ;BRGH 
    ;...................................
;		movlw     10010000B       ;SPEN,RX9,SREN,CREN,ADDEN,FERR,OERR,RX9D/parita
;		movwf     RC1STA	        ;str.432  //SPEN,CREN
    ;................................................
;		banksel   RA0PPS	        ;PPS str.190
;		movlw     0x0F	        ;Tx na RA0
;		movwf     RA0PPS
;		banksel   RX1DTPPS
;		movlw     0x01	    ;01 ;RA1
;		movwf     RX1DTPPS          ;RX na PORTA,1
;		banksel   PIE3		;str.125
;		bsf	      PIE3,5	    ;RC1IE        ;povoleni preruseni od RC
;		bsf	      INTCON,6	    ;PEIE
;		bsf       INTCON,7	    ;GIE	;povoli preruseni 
		return
;===============================================================================    

;===============================================================================    
_COMPARATOR_MODULE:    
;------------------ COMPARATOR MODULE  >Page: 244<   -----------------
;===============================================================================    
		
		return 
;===============================================================================    
_TIMER1_MODULE:	
;===============================================================================		          
;--------- TIMER1/3/5 MODULE ----------------- Page: 266  ---------
		return
;===============================================================================
_ADC_MODULE:			;Str.312 
;===============================================================================    
;   Merime Sondy, press a teplotu
;	Lze pouzit pouze vstupy:  RA0,RA1,RA2,RA4,RA5,RB5,RB6,RB7,RC2,RC3,RC4,RC5	
;		
;--------- ANALOG-TO-DIGITAL CONVERTER (ADC)- Page:312  -----------
		;Register Summary - ADC Control: str.517
		
/* ADC Conversion Procedure (Basic Mode)
This is an example procedure an Analog-to-Digital Conversion:
1. Configure Port:
a. Disable pin output driver (Refer to the TRISx register)
b. Configure pin as analog (Refer to the ANSELx register)
2. Configure the ADC module:
a. Select the ADC conversion clock
b. Configure voltage reference
c. Select the ADC input channel (precharge + acquisition)
d. Turn on the ADC module
3. Configure the ADC interrupt (optional):
a. Clear the ADC interrupt flag
b. Enable the ADC interrupt
c. Enable the peripheral interrupt (PIE bit)
d. Enable the global interrupt (GIE bit) (see the Note 1 below)
4. If ADACQ = 0, software must wait the required acquisition time (see the Note 2 below).
5. Start conversion by setting the GO bit.
6. Wait for the ADC conversion to complete by one of the following:
a. Polling the GO bit
		*/
		banksel	ADCON0			;str.532
		bsf		ADCON0,7		;ON		;enabled
		bcf		ADCON0,2		;FRM		;leve zarovnani
		bsf		ADCON0,4		;CS		;FRC oscilator
		;.....................................
		banksel	ADREF
		movlw   00000011B     ;str.537
		movwf	ADREF			;FVR
		;.....................................
		banksel	ADPCH			;str. 528
		movlw   010001B			;RC1
		movwf	ADPCH
		banksel	FVRCON			;str.494
		movlw   10000001B			;On,1.024
		movwf	FVRCON
		return
;===============================================================================    

;===============================================================================    
_START_OSTATNI:	
		banksel PORTA
		movlw   0
		movwf   SEC
		movlw   10
		movwf   CLOCK_10ms
		movlw   10
		movwf   CLOCK_01s
		movlw   100
		movwf   CLOCK_1ms
    ;-------------------------------------------
	
		clrf	SEC
		clrf	MIN
		clrf	TIM
		movlw	0x05	
		movwf	TO_24HH			;
		movlw	0xA0	
		movwf	TO_24HL
    ;-------------------------------------------
		call	TIMER_TO_VENTIL			;spusti odposteni	
		return
	;
    ;.........  P R E V O D Y ......................................................
;=============================================================================== 

;=============================================================================== 	

		
	